%% Batera ANR26650M1 - A123 Systems
clear
clc

Ns = 200; % Nmero de celdas en serie
Np = 10; % Nmero de celdas en paralelo

%  Parmetros de la batera:
Q = 2.3; % Capacidad mxima a la temperatura nominal (Ah)
Eo = 3.3678; % Tensin constante de circuito abierto a la temperatura nominal (V)

K = 0.0029; % Constante de polarizacin a la temperatura nominal (Ohmios)
Rohm = 0.01; % Resistencia hmica (Ohmios)
Cpol = 0; % Capacidad de polarizacin (V/Ah)


% Constantes:
Alpha = 1093.6; % Exponente alfa de la constante de polarizacin (K)
Beta = 8390.6; % Exponente beta de la resistencia hmica (K)

A = 0.3446; % Tensin exponencial (V)
B = 13.0435; % Capacidad exponencial (1/Ah)

Tf = 10; % Constante del filtro de corriente
Kc = 0.1; % Constante del trmino 2 para el clculo de E durante la carga


% Temperaturas:
Ta = 25; % Temperatura ambiente (C)
To = 298.15; % Temperatura nominal a la que se han medido todos los parmetros que dependen de esta (K)

% Constantes del modelo trmico:
dE_dT = 0.000010001; % Variacin de la tensin de circuito abierto con la temperatura (V/K)
dQ_dT = 0.0037; % Variacin de la capacidad con la temperatura (Ah/K)
Rout = 0.6; % Resistencia trmica convectiva (K/W)
Tth = 1000; % Constante de tiempo trmica (s)


% Constantes del modelo de capacidad (cycling):
a = 2.091620116180383e-08; % Trmino cuadrtico del polinomio de temperatura (1/K^2)
b = -1.217949508593764e-05; % Trmino lineal del polinomio de temperatura (1/K)
c = 0.001802766883936; % Trmino independiente del polinomio de temperatura 
d = -1.708177699275979e-06; % Constante del trmino exponencial del acoplamiento entre la temperatura y el Crate (1/K)
e = 0.055578784861400; % Constante del trmino exponencial del Crate

% Constantes del modelo de capacidad (calendar):
f = 5.980801169706742e06; % Constante del calendar ageing (Ah/das^0.5)
g = 0.689770643186819; % Constante del trmino exponencial del SOC
h = -6.464711916845157e03; % Constante del trmino exponencial de la temperatura (1/K)


% Valores crticos de la batera
Umax = 3.7*Ns; % Tensin mxima admisible en bornes de la batera (V)
Umin = 2*Ns; % Tensin mnima admisible en bornes de la batera (V)
Tcrit = 65; % Temperatura mxima admisible en cada celda de la batera (C)


% Consignas del ensayo:
Id = Q*3*Np; % Corriente en valor absoluto durante la descarga (A)
Ic = Q*3*Np; % Corriente en valor absoluto durante la carga (A)
SOC0 = 100; % Estado de carga inicial (%)
w = 1.5; % Nmero de ciclos diarios (ciclos/da)
